// fogcoord.vs
//
// Standardowe przeksztacenie wierzchokw,
// wiato rozproszone oraz refleksy
// wsprzdne mgy na poziomie wierzchokw

uniform vec3 lightPos0;

void main(void)
{
    // przeksztacenia model-widok
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

    vec3 N = normalize(gl_NormalMatrix * gl_Normal);
    vec4 V = gl_ModelViewMatrix * gl_Vertex;
    vec3 L = normalize(lightPos0 - V.xyz);
    vec3 H = normalize(L + vec3(0.0, 0.0, 1.0));
    const float specularExp = 128.0;

    // owietlenie wiatem rozproszonym
    float NdotL = dot(N, L);
    vec4 diffuse = gl_Color * vec4(max(0.0, NdotL));

    // refleksy wietlne
    float NdotH = dot(N, H);
    vec4 specular = vec4(pow(max(0.0, NdotH), specularExp));

    // wsprzdne mgy: odlego wierzchoka od obserwatora
    gl_FogFragCoord = length(V);

    // sumowanie owietlenia i refleksu
    gl_FrontColor = diffuse + specular;
}

